# Amazon chat UI deployment in SF Community page

Salesforce community builder allows customers to design and deploy their own customer portal based on the templates available. Each template has SF lightning components that you can drag and drop to build the customer portal. Currently the community builder has a lightning component for chat that integrates with salesforce live chat. In this post we will explain on how to deploy amazon chat UI as a lightning component into salesforce community builder so that customers can drag/drop this new lightning component which integrates with amazon connect. This way the customer portal will be enabled with amazon chat UI with which customers can chat with amazon connect agents.

## Prerequisites
* Salesforce account for a sandbox.
* Communities enabled for the same salesforce account.
* [SFDX installed and configured.](https://developer.salesforce.com/docs/atlas.en-us.sfdx_setup.meta/sfdx_setup/sfdx_setup_install_cli.htm).
* Deploy amazon connect chat cloud formation template. Follow the deployment steps outlined in the below link:
[CloudFormation Deployment Steps](https://github.com/amazon-connect/amazon-connect-chat-ui-examples/tree/master/cloudformationTemplates/asyncCustomerChatUX)

## Repository content
* **sfdx-project.json**: Required by Salesforce DX. Configures your project.  Use this file to specify the parameters that affect your Salesforce development project.
* **config/project-scratch-def.json**: Sample file that shows how to define the shape of a scratch org.  You reference this file when you create your scratch org with the force:org:create command.   
* **force-app**: Directory that contains the source for the sample Force.com app and tests.   
* **.project**:  Required by the Eclipse IDE.  Describes the Eclipse project. 
* **.gitignore**:  Optional Git file. Specifies intentionally untracked files that you want Git (or in this case GitHub) to ignore.

## Set Up

1. Clone the repo
    ```
    git clone ssh://git.amazon.com/pkg/Amazon_sf_chat_ui
    ```
2. Then, open the directory
    ```
    cd Amazon_sf_chat_ui
    ```
3. Authorize your org using Web-Based flow
    * Set the `sfdcLoginUrl` parameter in `sfdx-project.json` at root to your My Domain login URL and save the file.
        ```
        "sfdcLoginUrl" : "https://somethingcool.my.salesforce.com"
        ```
    * Run the force:auth:web:login CLI command.
        ```
        sfdx force:auth:web:login
        ```
4. Now your salesforce login page will be opened in a browser. Login and authorize sfdx.

5. Deploy the lightning component using your login username to salesforce.
   ```
   sfdx force:source:deploy -u <yourusername@amazonconnect.sdo1> -p force-app/main/default/aura/ACChatService
   ```
6. Open your org using the below command.
   ```
   sfdx force:org:open -u <yourusername@amazonconnect.sdo1>
   ```
7. Now the lightning component AS Chat Service should have been deployed in your account. Go to setup -> communities -> All Communities.
8. Click `Builder` to open the community builder of the community page where you would want to add this amazon chat ligtning component.

![builder diagram](./images/builder.png)


9. Drag and drop `AC Chat Service component` to the footer of the community page.You will be able to find it under custom components.


![chatcomponent diagram](./images/chatcomponent.png)


![footer diagram](./images/footer.png)

10. Configure the `AC instance id` and `AC contact flow id` close the property window.


![properties diagram](./images/properties.png)


11. Publish the community page and test to see if you receive chats.


![publish diagram](./images/publish.png)
